<% option explicit 

' Search scripts para busca
' Reescrito por Iremar Afonso (iremar@mouse.com.br)
' www.mouse.com.br
' do original - Erick Norman
%>

<html><head><title>Busca no site</title></head><body>

<%
'/////////////////////////////////////////////////////////////////////////////////
'// Inicializao

' Declara as variveis.
dim target, firstRow, rowCount

' Pega os paramnetros com request.
target = Request("target") ' The search request
firstRow = Request("fr") ' First row of results to display
rowCount = Request("rc") ' Record Count - number of rows to show

' Difine um valor default se nada for encontrado.
if firstRow = "" or not IsNumeric(firstRow) Then 
firstRow = 1
else
firstRow = CInt(firstRow)
End If
if rowCount = "" or not IsNumeric(rowCount) Then 
rowCount = 10
else
rowCount = CInt(rowCount)
End If

Dim ScriptName, ServerName
ScriptName = Request.ServerVariables("SCRIPT_NAME")
ServerName = Request.ServerVariables("SERVER_NAME")

' Constroi uma URL bsica com botes de navegao
dim URL
URL = ScriptName & "?target=" & Server.URLEncode(target)
URL = URL & "&rc=" & Server.URLEncode(rowCount)

'/////////////////////////////////////////////////////////////////////////////////
'// O formurio

%>
<form name="searchForm" action="<%=ScriptName%>">
<b>Search for:</b>
<INPUT TYPE="text" NAME="target" SIZE="45" MAXLENGTH="100" VALUE="<%=target%>">
<INPUT TYPE="submit" VALUE=" Search ">
</form>

<hr size=2 noshade><br>

<% 

DoSearch target

'/////////////////////////////////////////////////////////////////////////////////
'// Performance da busca

sub DoSearch(target)

on error resume next
if target <> "" then

dim strQuery
' strQuery = "$contents " & target ' O texto a ser localizado
strQuery = "(#filename *.asp) AND " &_
"(NOT #vpath *\_vti*) AND (NOT #vpath *\cgi-bin*) AND " &_
"(NOT #vpath *\IISOrigBackup*) AND (NOT #vpath *\scripts*) AND " &_
"(NOT #vpath *\_private*) AND " &_
"(" & target & ")"

' Daqui pra frente esta tudo original, sem alterao.
' Create the Index Server query object, setting the columns, the sort to
' descending, the max records to 300, and the query string to the given
' target. Note that the query string specifies, with NOT and the
' #vpath operators, that any files in the *\_vti path, should be excluded.
' (_vti* directories contain FrontPage Extension files, and we don't want
' users browsing them.)

dim ixQuery ' Index Server query object.
set ixQuery = Server.CreateObject("ixsso.Query")
if (Err.description <> "") Then
Response.Write ("<p><b>Query object Error: " & Err.description & ".</b></p>" & vbCRLF)
Exit sub
end if

ixQuery.Columns = "doctitle, vpath, filename, size, write, characterization, rank"
ixQuery.SortBy = "rank[d], doctitle"
ixQuery.MaxRecords = 300
ixQuery.Query = strQuery

' Create a search utility object to allow us to specify the search type as 'deep',
' meaning it will search recursively down through the directories
dim util 
set util = Server.CreateObject("ixsso.Util")
util.AddScopeToQuery ixQuery, Server.MapPath("/"), "deep"
if (Err.description <> "") Then
Response.Write ("<p><b>Search Utility Error: " & Err.description & ".</b></p>" & vbCRLF)
Exit sub
end if

' Run the query (i.e. create the recordset).
dim queryRS ' Query recordset.
set queryRS = ixQuery.CreateRecordSet("nonsequential")

' Check the query result. If it timed out or return no records, then show
' an appropriate message. Otherwise, show the hits.
if (Err.description <> "") Then
Response.Write ("<p><b>Search Recordset Error: " & Err.description & ".</b></p>" & vbCRLF)
Exit sub
Else
'Response.Write "<br><font size=1>Rows = " & queryRS.RecordCount & ", EOF = " & queryRS.EOF & ", BOF = " & queryRS.BOF & "</font>"

if queryRS is Nothing Then
Response.Write ("<p>Query returned no matches.</p>" & vbCRLF) 
elseif (ixQuery.QueryTimedOut) then
Response.Write ("<p><b>Error: " & timedOut_Text & ".</b></p>" & vbCRLF)
elseif (queryRS.EOF or queryRS.BOF or queryRS.RecordCount <= 0) then
Response.Write ("<p>No matches found.</p>" & vbCRLF)
else
queryRS.PageSize = rowCount
call showHits(queryRS)
if (Err.number <> 0) Then
Response.Write ("<p><b>Record Display Error: " & Err.description & ".</b></p>" & vbCRLF)
End If 
end if
End If

' Clean up
queryRS.close
set queryRS = nothing
set ixQuery = nothing
set util = nothing

End if 
end Sub

' showHits(): Displays the query hits from the query recordset.
'
sub showHits(queryRS)
dim recordNumber ' record number
dim docTitle ' document title
dim endRow ' last row being displayed
dim prevRow ' row to display for "prev" option
dim nextRow ' row to display for "next" option
dim lastRow ' row to display for "last" option
dim remainder ' remainder (used to determine if last page is short)
dim recordCount ' numner of records returned

recordCount = queryRS.RecordCount
if firstRow > recordCount Then firstRow = 1 

endRow = firstRow + RowCount-1 ' Last row on page to show
if endRow > recordCount Then endRow = recordCount

prevRow = firstRow - RowCount ' Start of previous page's rows
if PrevRow < 1 Then PrevRow = 1

nextRow = endRow + 1 ' Start of next pages rows. May be > CommentCount 

remainder = recordCount mod RowCount
if remainder = 0 Then
lastRow = recordCount - RowCount + 1
else
lastRow = recordCount - remainder + 1
End If
if lastRow < 1 Then lastRow = 1 ' Start of last pages rows

' Go to the top of the record set, then move forward to the record that
' corresponds to the first row.
queryRS.MoveFirst()

if (firstRow > 1) then
queryRS.Move(CInt(firstRow) - 1)
end if

' Show the summary info.: # of records found and range showing.
%>
<table border=0>
<tr><td colspan=2>

<table border=0 width=100%><tr>
<td nowrap><b>Found:</b> <%=queryRS.RecordCount%>    <b>Showing:</b> <%=firstRow%> - <%=endRow%></td> 
<td align=right nowrap>
<% if firstRow <> "1" Then %>
<a href="<%=URL&"&fr=1"%>">First</a> |
<% Else %>
First |
<% End If %>
<% if firstRow <> "1" Then %>
<a href="<%=URL&"&fr="&prevRow%>">Prev</a> |
<% Else %>
Prev |
<% End If %>
<% if firstRow + RowCount < recordCount Then %>
<a href="<%=URL&"&fr="&nextRow%>">Next</a> |
<% Else %>
Next |
<% End If %>
<% if firstRow + RowCount < recordCount Then %>
<a href="<%=URL&"&fr="&lastRow%>">Last</a>
<% Else %>
Last
<% End If %>
</td></tr>
</table></td></tr>

<tr><td colspan=2> </td></tr>
<%
' Show the records.

recordNumber = firstRow

do while ((not queryRS.EOF) and (recordNumber <= endRow))

' Get the document title. If it's blank, set it to "Untitled".
docTitle = queryRS("doctitle")

if docTitle = "" then docTitle = "Untitled"

' Show the record #, link to the document, URL, and characterization.
Response.Write "<tr>"
Response.Write "<td valign=top>" & recordNumber & ".</td>"
Response.Write "<td valign=top>"
Response.Write "<a href='" & queryRS("vpath") & "'>" & docTitle & "</a><br>"
Response.Write "<b>URL: </b> http://" & ServerName & queryRS("vpath") & "<br>"
Response.Write Server.HTMLEncode(queryRS("characterization"))
Response.Write "</td>"
Response.Write "</tr>"

recordNumber = recordNumber + 1
queryRS.MoveNext()
loop

' Display the navigation links.
%>
<tr><td colspan=2> </td></tr>

<tr><td colspan=2 align=center>
<% if firstRow <> "1" Then %>
<a href="<%=URL&"&fr=1"%>">First</a> |
<% Else %>
First |
<% End If %>
<% if firstRow <> "1" Then %>
<a href="<%=URL&"&fr="&prevRow%>">Prev</a> |
<% Else %>
Prev |
<% End If %>
<% if firstRow + RowCount < recordCount Then %>
<a href="<%=URL&"&fr="&nextRow%>">Next</a> |
<% Else %>
Next |
<% End If %>
<% if firstRow + RowCount < recordCount Then %>
<a href="<%=URL&"&fr="&lastRow%>">Last</a>
<% Else %>
Last
<% End If %>
</td></tr>

</table>

<% end sub %>

</body>
</html>
